using System;
using Server;
using Server.Mobiles;

namespace Server.Items
{
    public class SlayerLongbowOfEvolution : SlayerLongbow
    {
        private int mEvolutionPoints = 0;

        [CommandProperty(AccessLevel.GameMaster)]
        public int EvolutionPoints { get { return mEvolutionPoints; } set { mEvolutionPoints = value; } }

        public override int ArtifactRarity { get { return 500; } }
        public override int InitMinHits { get { return 255; } }
        public override int InitMaxHits { get { return 255; } }

        [Constructable]
        public SlayerLongbowOfEvolution()
        {
            Name = "Slayer Longbow of Evolution";
            Hue = 2539;

            Attributes.Luck = 100;

            Attributes.WeaponDamage = 1;
            Attributes.WeaponSpeed = 10;
            Attributes.SpellChanneling = 1;
            
            Slayer = Slayer2;
            Slayer2 = SlayerName.None;
        }

        public SlayerLongbowOfEvolution(Serial serial)
            : base(serial)
        {
        }
        
		public override bool OnEquip( Mobile from )
		{
			if ( from is PlayerMobile )
            this.BlessedFor = from;
         else if ( from is BaseCreature && ((BaseCreature)from).ControlMaster != null )
               this.BlessedFor = ((BaseCreature)from).ControlMaster;
               
         this.InvalidateProperties();
			return base.OnEquip( from );							
		}
		
        public override void OnHit(Mobile attacker, Mobile defender, double Damagebonus)
        {
            if ( SwordOfEvolution.ApplyGain( attacker, defender, this, ref mEvolutionPoints ) )
               this.Name = "Slayer Longbow of Evolution (" + mEvolutionPoints.ToString() + ")";

            base.OnHit(attacker, defender,Damagebonus);
        }

        public override void Serialize(GenericWriter writer)
        {
            base.Serialize(writer);

            writer.Write((int)2);
            writer.Write(mEvolutionPoints);
        }

        public override void Deserialize(GenericReader reader)
        {
            base.Deserialize(reader);

            int version = reader.ReadInt();
            mEvolutionPoints = reader.ReadInt();
            
            if ( version == 0 && mEvolutionPoints == 10001 )
               mEvolutionPoints = 10000;
               
            if ( version == 1 && mEvolutionPoints == 10001 )
            {
               this.MinDamage = AOS.Scale( this.MinDamage, 130 );
               this.MaxDamage = AOS.Scale( this.MaxDamage, 130 );
            }
        }
    }
}